/* 
 *  UpdateCustomerNameRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class UpdateCustomerNameRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(UpdateCustomerNameRequest.class);
    private final String title;
    private final String firstName;
    private final String lastName;

    public UpdateCustomerNameRequest(String interactionID, String title, String firstName, String lastName) {
        super(LOG, interactionID);
        this.title = title;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getInteraction().updateCustomerName(title, firstName, lastName);
        LOG.trace(methodName + "-");
        return null;
    }
}
